
# Objects

## `Balance`

The balance of a particular asset for a wallet address.

**fields:**

`owner`: [`Address!`](/docs/reference/scalars/#address)

An EOA account represented by 32 bytes.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount of the selected asset id as an unsigned 64 bit number.

`assetId`: [`AssetId!`](/docs/reference/scalars/#assetid)

A 32 byte representation of the asset.

## `BalanceFilterInput`

The filter input type used to filter the `balances` query.

**fields:**

`owner`: [`Address!`](/docs/reference/scalars/#address)

The owner address of the balances.

## `Blob`

Information about a blob transaction in the network.

**fields:**

`id`: [`BlobId!`](/docs/reference/scalars/#blobid)

The transaction identifier for the blob.

`bytecode`: [`HexString!`](/docs/reference/scalars/#hexstring)

The blob bytecode.

## `Block`

Information about a block in the network.

**fields:**

`version`: [`BlockVersion!`](/docs/reference/enums/#blockversion)

The version of the block.

`id`: [`BlockId!`](/docs/reference/scalars/#blockid)

A unique identifier for the block.

`height`: [`U32!`](/docs/reference/scalars/#u32)

The height of the block.

`header`: [`Header!`](#header)

Metadata about a block.

`consensus`: [`Consensus!`](/docs/reference/unions/#consensus)

The type of consensus used.

`transactionIds`: [`TransactionId!`](/docs/reference/scalars/#transactionid)

An array of transaction ids included in the block only.

`transactions`: [`[Transaction!]!`](#transaction)

An array of transactions included in the block.

## `Breakpoint`

A breakpoint during debugging.
Defined as a tuple of a contract ID and relative `pc` offset inside it.

**fields:**

`contract`: [`ContractId!`](/docs/reference/scalars/#contractid)

The contract address.

`pc`: [`U64!`](/docs/reference/scalars/#u64)

The value of the program counter register `$pc`, which is the memory address of the current instruction.

## `ChainInfo`

Information about the base chain. At a very high level `chainInfo` helps you understand what Fuel chain you're connected to and the different parameters of this chain.

**fields:**

`name`: `String!`

The human-readable string name of the chain. i.e. `Upgradable Testnet`.

`latestBlock`: [`Block!`](#block)

The most recently created block.

`daHeight`: [`U64!`](/docs/reference/scalars/#u64)

The height of the base chain via relayer (i.e. Ethereum or DA)

`consensusParameters`: [`ConsensusParameters!`](#consensusparameters)

The consensus parameters used to validate blocks.

`gasCosts`: [`GasCosts!`](#gascosts)

The gas cost of each opcode.

## `ChangeOutput`

A transaction output that changes the unspent coins in a UTXO.

**fields:**

`to`: [`Address!`](/docs/reference/scalars/#address)

The recipient address of the coins.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount of coins.

`assetId`: [`AssetId!`](/docs/reference/scalars/#assetid)

The asset id for the coins.

## `Coin`

Information about a coin.

**fields:**

`utxoId`: [`UtxoId!`](/docs/reference/scalars/#utxoid)

A unique 32 byte identifier for a UTXO.

`owner`: [`Address!`](/docs/reference/scalars/#address)

The owner address of the coins.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount of coins.

`assetId`: [`AssetId!`](/docs/reference/scalars/#assetid)

The asset id of the coin.

`blockCreated`: [`U32!`](/docs/reference/scalars/#u32)

The block when the coins were created.

`txCreatedIdx`: [`U64!`](/docs/reference/scalars/#u64)

The index of the transaction that created this coin.

## `CoinFilterInput`

The filter input type for the `coins` query.

**fields:**

`owner`: [`Address!`](/docs/reference/scalars/#address)

The owner of the coins.

`assetId`: [`AssetId`](/docs/reference/scalars/#assetid)

The asset id of the coins.

## `CoinOutput`

A type representing a coin output.

**fields:**

`to`: [`Address!`](/docs/reference/scalars/#address)

The receiver address of the output coins.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount of coins in the output.

`assetId`: [`AssetId!`](/docs/reference/scalars/#assetid)

The asset id for the output coins.

## `ConsensusParameters`

The consensus parameters used for validating blocks.

**fields:**

`version`: [`ConsensusParametersVersion!`](/docs/reference/unions/#consensusparametersversion)

The version of the consensus parameters.

`txParams`: [`TxParameters!`](#txparameters)

The allowed parameters of transactions.

`predicateParams`: [`PredicateParameters!`](#predicateparameters)

The allowed parameters of predicates.

`scriptParams`: [`ScriptParameters!`](#scriptparameters)

The allowed parameters of scripts.

`contractParams`: [`ContractParameters!`](#contractparameters)

The allowed parameters of contracts.

`feeParams`: [`FeeParameters!`](#feeparameters)

The allowed parameters of fees.

`baseAssetId`: [`AssetId!`](/docs/reference/scalars/#assetid)

The asset id of the "base" asset used for gas fees.

`blockGasLimit`: [`U64!`](/docs/reference/scalars/#u64)

The maximum amount of gas spend allowed in a block.

`blockTransactionSizeLimit`: [`U64!`](/docs/reference/scalars/#u64)

The maximum transaction slots in a block.

`chainId`: [`U64!`](/docs/reference/scalars/#u64)

A unique identifier for the chain.

`gasCosts`: [`GasCosts!`](#gascosts)

The gas cost of each opcode.

`privilegedAddress`: [`Address!`](/docs/reference/scalars/#address)

The address used to authorize network upgrades via the `Upgrade` transaction.

## `ConsensusParametersPurpose`

Details about the consensus parameters that are being upgraded.

**fields:**

`witnessIndex`: [`U16!`](/docs/reference/scalars/#u16)

The index of the witness in the `witnesses` field that contains the serialized consensus parameters. For an upgrade to consensus parameters, the upgraded parameters are stored as a witness in the transaction.

`checksum`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The hash of the serialized consensus parameters.
Since the serialized consensus parameters live inside the transaction witnesses (which is malleable data), any party can override them. The `checksum` is used to verify that the data was not modified or tampered with.

## `Contract`

An object representing a deployed contract.

**fields:**

`id`: [`ContractId!`](/docs/reference/scalars/#contractid)

The contract address.

`bytecode`: [`HexString!`](/docs/reference/scalars/#hexstring)

The contract bytecode.

`salt`: [`Salt!`](/docs/reference/scalars/#salt)

A unique identifier for the contract.

## `ContractBalance`

An object representing the balance of a deployed contract for a certain asset.

**fields:**

`contract`: [`ContractId!`](/docs/reference/scalars/#contractid)

The contract address.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The contract balance for the given asset.

`assetId`: [`AssetId!`](/docs/reference/scalars/#assetid)

The asset id for the coins.

## `ContractBalanceFilterInput`

The filter input type for the `contractBalances` query.

**fields:**

`contract`: [`ContractId!`](/docs/reference/scalars/#contractid)

The contract id that the query will return balances for.

## `ContractCreated`

The output type from deploying a contract.

**fields:**

`contract`: [`Contract!`](#contract)

The contract that was created.

`stateRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The initial state root of contract.

## `ContractOutput`

The output type from a transaction that changed the state of a contract.

**fields:**

`inputIndex`: `Int!`

The index of the input.

`balanceRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The root of amount of coins owned by contract after transaction execution.

`stateRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The state root of contract after transaction execution.

## `ContractParameters`

Contract-specific consensus parameters.

**fields:**

`version`: [`ContractParametersVersion!`](/docs/reference/unions/#contractparametersversion)

The version of the contract-specific consensus parameters.

`contractMaxSize`: [`U64!`](/docs/reference/scalars/#u64)

Maximum size of a contract in bytes.

`maxStorageSlots`: [`U64!`](/docs/reference/scalars/#u64)

Maximum number of storage slots.

## `DryRunTransactionExecutionStatus`

Details about the status of a transaction dry run.

**fields:**

`id`: [`TransactionId!`](/docs/reference/scalars/#transactionid)

The transaction ID.

`status`: [`DryRunTransactionStatus!`](/docs/reference/unions/#dryruntransactionstatus)

The status of the transaction dry run.

`receipts`: [`[Receipt!]!`](#receipt)

The receipts for the transaction dry run.

## `DryRunFailureStatus`

The status details of a failed transaction dry run.

**fields:**

`programState`: [`ProgramState`](#programstate)

The state of the program execution.

`reason`: `String!`

The reason why the transaction dry run failed.

`receipts`: [`[Receipt!]!`](#receipt)

The transaction dry run receipts.

`totalGas`: [`U64!`](/docs/reference/scalars/#u64)

The total amount of gas used.

`totalFee`: [`U64!`](/docs/reference/scalars/#u64)

The total fee for the transaction.

## `DryRunSuccessStatus`

The status details of a successful transaction dry run.

**fields:**

`programState`: [`ProgramState`](#programstate)

The state of the program execution.

`receipts`: [`[Receipt!]!`](#receipt)

The transaction dry run receipts.

`totalGas`: [`U64!`](/docs/reference/scalars/#u64)

The total amount of gas used.

`totalFee`: [`U64!`](/docs/reference/scalars/#u64)

The total fee for the transaction.

## `EstimateGasPrice`

The estimated gas price for a transaction.

**fields:**

`gasPrice`: [`U64!`](/docs/reference/scalars/#u64)

## `ExcludeInput`

The input type for the `resourcesToSpend` query that defines what UTXOs and messages to exclude.

**fields:**

`utxos`: [`[UtxoId!]!`](/docs/reference/scalars/#utxoid)

An array of UTXO IDs to exclude.

`messages`: [`[Nonce!]!`](/docs/reference/scalars/#nonce)

An array of message IDs to exclude.

## `FailureStatus`

The status type of a transaction that has failed.

**fields:**

`transactionId`: [`TransactionId!`](/docs/reference/scalars/#transactionid)

A unique transaction id.

`blockHeight`: [`U32`](/docs/reference/scalars/#u32)

The block height for the failed transaction.

`block`: [`Block!`](#block)

The block number for the failed transaction.

`transaction`: [`Transaction!`](#transaction)

The transaction itself.

`time`: [`Tai64Timestamp!`](/docs/reference/scalars/#tai64timestamp)

The time the transaction failed.

`reason`: `String!`

The reason why the transaction failed.

`programState`: [`ProgramState`](#programstate)

The state of the program execution.

`receipts`: [`[Receipt!]!`](#receipt)

The receipts for the transaction.

`totalGas`: [`U64!`](/docs/reference/scalars/#u64)

The total amount of gas used.

`totalFee`: [`U64!`](/docs/reference/scalars/#u64)

The total fee for the transaction.

## `FeeParameters`

The consensus parameters for fees.

**fields:**

`version`: [`FeeParametersVersion!`](/docs/reference/unions/#feeparametersversion)

The version of the consensus parameters.

`gasPriceFactor`: [`U64!`](/docs/reference/scalars/#u64)

The dynamic adjustment of gas costs.

`gasPerByte`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost per byte.

## `GasCosts`

The breakdown of the gas costs of each opcode.

**fields:**

`version`: [`GasCostsVersion!`](/docs/reference/unions/#gascostsversion)

The version of the gas-specific consensus parameters.

`add`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$add` ALU opcode.

`addi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$addi` ALU opcode.

`aloc`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$aloc` memory opcode.

`and`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$and` ALU opcode.

`andi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$andi` ALU opcode.

`bal`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$bal` contract opcode.

`bhei`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$bhei` contract opcode.

`bhsh`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$bhsh` contract opcode.

`burn`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$burn` contract opcode.

`cb`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$cb` contract opcode.

`cfei`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$cfei` memory opcode.

`cfsi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$cfsi` memory opcode.

`div`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$div` ALU opcode.

`divi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$divi` ALU opcode.

`ecr1`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$ecr1` cryptographic opcode.

`eck1`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$eck1` cryptographic opcode.

`ed19`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$ed19` cryptographic opcode.

`eq`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$eq` ALU opcode.

`exp`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$exp` ALU opcode.

`expi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$expi` ALU opcode.

`flag`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$flag` opcode.

`gm`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$gm` opcode.

`gt`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$gt` opcode.

`gtf`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$gtf` ALU opcode.

`ji`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$ji` control flow opcode.

`jmp`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jmp` control flow opcode.

`jne`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jne` control flow opcode.

`jnei`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jnei` control flow opcode.

`jnzi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jnzi` control flow opcode.

`jmpf`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jmpf` control flow opcode.

`jmpb`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jmpb` control flow opcode.

`jnzf`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jnzf` control flow opcode.

`jnzb`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jnzb` control flow opcode.

`jnef`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jnef` control flow opcode.

`jneb`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$jneb` control flow opcode.

`lb`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$lb` memory opcode.

`log`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$log` contract opcode.

`lt`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$lt` ALU opcode.

`lw`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$lw` memory opcode.

`mint`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$mint` contract opcode.

`mlog`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$mlog` ALU opcode.

`modOp`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$modOp` opcode.

`modi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$modi` ALU opcode.

`moveOp`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$moveOp` ALU opcode.

`movi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$movi` ALU opcode.

`mroo`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$mroo` ALU opcode.

`mul`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$mul` ALU opcode.

`muli`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$muli` ALU opcode.

`mldv`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$mldv` ALU opcode.

`noop`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$noop` ALU opcode.

`not`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$not` ALU opcode.

`or`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$or` ALU opcode.

`ori`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$ori` ALU opcode.

`poph`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$poph` opcode.

`popl`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$popl` opcode.

`pshh`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$pshh` opcode.

`pshl`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$pshl` opcode.

`ret`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$ret` opcode.

`rvrt`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$rvrt` contract opcode.

`sb`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$sb` memory opcode.

`sll`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$sll` ALU opcode.

`slli`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$slli` ALU opcode.

`srl`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$srl` ALU opcode.

`srli`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$srli` ALU opcode.

`srw`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$srw` contract opcode.

`sub`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$sub` ALU opcode.

`subi`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$subi` ALU opcode.

`sw`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$sw` memory opcode.

`sww`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$sww` contract opcode.

`time`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$time` contract opcode.

`tr`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$tr` contract opcode.

`tro`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$tro` contract opcode.

`wdcm`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wdcm` ALU opcode.

`wqcm`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wqcm` ALU opcode.

`wdop`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wdop` ALU opcode.

`wqop`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wqop` ALU opcode.

`wdml`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wdml` ALU opcode.

`wqml`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wqml` ALU opcode.

`wddv`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wddv` ALU opcode.

`wqdv`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wqdv` ALU opcode.

`wdmd`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wdmd` ALU opcode.

`wqmd`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wqmd` ALU opcode.

`wdam`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wdam` ALU opcode.

`wqam`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wqam` ALU opcode.

`wdmm`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wdmm` ALU opcode.

`wqmm`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$wqmm` ALU opcode.

`xor`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$xor` ALU opcode.

`xori`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of using the `$xori` ALU opcode.

`alocDependentCost`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$aloc` contract opcode.

`bldd`: [`DependentCost`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$bldd` contract opcode.

`bsiz`: [`DependentCost`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$bsiz` contract opcode.

`cfe`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$cfe` contract opcode.

`cfeiDependentCost`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$cfei` contract opcode.

`call`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$call` contract opcode.

`ccp`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$ccp` contract opcode.

`croo`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$croo` contract opcode.

`csiz`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$csiz` contract opcode.

`ed19DependentCost`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$ed19` contract opcode.

`k256`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$k256` cryptographic opcode.

`ldc`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$ldc` contract opcode.

`logd`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$logd` contract opcode.

`mcl`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$mcl` memory opcode.

`mcli`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$mcli` memory opcode.

`mcp`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$mcp` memory opcode.

`mcpi`: [`DependentCost`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$mcpi` memory opcode.

`meq`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$meq` memory opcode.

`retd`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$retd` contract opcode.

`s256`: [`DependentCost`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$mcpi` cryptographic opcode.

`scwq`: [`DependentCost`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$scwq` cryptographic opcode.

`smo`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$smo` contract opcode.

`srwq`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$srwq` contract opcode.

`swwq`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of using the `$swwq` contract opcode.

`contractRoot`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost calculating the `contractRoot`.

`stateRoot`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost calculating the `stateRoot`.

`vmInitialization`: [`DependentCost!`](/docs/reference/unions/#dependentcost)

The `dependent` gas cost of the `vmInitialization`.

`newStoragePerByte`: [`U64!`](/docs/reference/scalars/#u64)

The gas cost of storage per byte.

## `Genesis`

The genesis consensus type.

**fields:**

`chainConfigHash`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The chain configuration hash. The chain configuration defines what consensus type to use, what settlement layer to use, and the rules of block validity.

`coinsRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The binary Merkle tree root of all genesis coins.

`contractsRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The binary Merkle tree root of state, balances, and the contracts code hash of each contract.

`messagesRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The binary merkle tree root of all genesis messages.

`transactionsRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The binary Merkle tree root of all previous transactions.

## `HeavyOperation`

The operation dependent on the size of its inputs, and the time required per unit of input exceeding that of a single no-op operation

**fields:**

`base`: [`U64!`](/docs/reference/scalars/#u64)

The minimum gas that this operation can cost

`gasPerUnit`: [`U64!`](/docs/reference/scalars/#u64)

The gas is required to process a single unit

## `Header`

The header contains metadata about a certain block.

**fields:**

`version`: [`HeaderVersion!`](/docs/reference/enums/#headerversion)

The version of the header.

`id`: [`BlockId!`](/docs/reference/scalars/#blockid)

The current block id.

`daHeight`: [`U64!`](/docs/reference/scalars/#u64)

The block height for the data availability layer up to which (inclusive) input messages are processed.

`consensusParametersVersion`: [`U32!`](/docs/reference/scalars/#u32)

The version of the consensus parameters.

`stateTransitionBytecodeVersion`: [`U32!`](/docs/reference/scalars/#u32)

The version of the state transition bytecode.

`transactionsCount`: [`U64!`](/docs/reference/scalars/#u64)

The number of transactions in the block.

`messageReceiptCount`: [`U64!`](/docs/reference/scalars/#u64)

The number of receipt messages in the block.

`transactionsRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The merkle root of the transactions in the block.

`messageOutboxRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The Merkle root of the outgoing messages back to the data availability (DA) layer from Fuel, where the inputs are the IDs (`MessageId`) of the messages. The IDs are produced by executing transactions and collecting IDs from the receipts of the `Message` outputs.

`eventInboxRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The Merkle root of the incoming events from the data availability (DA) layer to Fuel, where the tree inputs are the hashes of these events.

`height`: [`U32!`](/docs/reference/scalars/#u32)

The block height.

`prevRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The merkle root of all previous consensus header hashes (not including this block).

`time`: [`Tai64Timestamp!`](/docs/reference/scalars/#tai64timestamp)

The timestamp for the block.

`applicationHash`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The hash of the serialized application header for this block.

## `InputCoin`

Information about a coin input.

**fields:**

`utxoId`: [`UtxoId!`](/docs/reference/scalars/#utxoid)

A unique 32 byte identifier for the UTXO.

`owner`: [`Address!`](/docs/reference/scalars/#address)

The owning address or predicate root.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount of coins.

`assetId`: [`AssetId!`](/docs/reference/scalars/#assetid)

The asset ID of the coins.

`txPointer`: [`TxPointer!`](/docs/reference/scalars/#txpointer)

A pointer to the transaction whose output is being spent.

`witnessIndex`: `Int!`

The index of the witness that authorizes spending the coin.

`predicateGasUsed`: [`U64!`](/docs/reference/scalars/#u64)

The amount of gas used in the predicate transaction.

`predicate`: [`HexString!`](/docs/reference/scalars/#hexstring)

The predicate bytecode.

`predicateData`: [`HexString!`](/docs/reference/scalars/#hexstring)

The predicate input parameters.

## `InputContract`

Information about a contract input.

**fields:**

`utxoId`: [`UtxoId!`](/docs/reference/scalars/#utxoid)

A unique 32 byte identifier for the UTXO.

`balanceRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The root of amount of coins owned by contract before transaction execution.

`stateRoot`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The state root of contract before transaction execution.

`txPointer`: [`TxPointer!`](/docs/reference/scalars/#txpointer)

A pointer to the TX whose output is being spent.

`contractId`: [`ContractId!`](/docs/reference/scalars/#contractid)

The input contract's ID.

## `InputMessage`

Information about a message input.

**fields:**

`sender`: [`Address!`](/docs/reference/scalars/#address)

The sender address of the message.

`recipient`: [`Address!`](/docs/reference/scalars/#address)

The recipient address of the message.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount sent in the message.

`nonce`: [`Nonce!`](/docs/reference/scalars/#nonce)

A nonce value for the message input, which is determined by the sending system and is published at the time the message is sent.

`witnessIndex`: `Int!`

The index of witness that authorizes spending the coin.

`predicateGasUsed`: [`U64!`](/docs/reference/scalars/#u64)

The amount of gas used in the predicate transaction.

`data`: [`HexString!`](/docs/reference/scalars/#hexstring)

The message data.

`predicate`: [`HexString!`](/docs/reference/scalars/#hexstring)

The predicate bytecode.

`predicateData`: [`HexString!`](/docs/reference/scalars/#hexstring)

The predicate input parameters.

## `LatestGasPrice`

Information about the latest price of gas.

**fields:**

`gasPrice`: [`U64!`](/docs/reference/scalars/#u64)

The gas price for the latest block produced.

`blockHeight`: [`U32!`](/docs/reference/scalars/#u32)

The block height for the latest block produced.

## `LightOperation`

The operation dependent on the size of its inputs, and the time required per unit of input less that of a single no-op operation

**fields:**

`base`: [`U64!`](/docs/reference/scalars/#u64)

The minimum gas that this operation can cost

`unitsPerGas`: [`U64!`](/docs/reference/scalars/#u64)

The units that can be processed with a single gas

## `MerkleProof`

Information about a merkle proof.

**fields:**

`proofSet`: [`[Bytes32!]!`](/docs/reference/scalars/#bytes32)

The proof set of the message proof.

`proofIndex`: [`U64!`](/docs/reference/scalars/#u64)

The index used to generate this proof.

## `Message`

Contains information about a message.

**fields:**

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount of base asset coins sent with the message.

`sender`: [`Address!`](/docs/reference/scalars/#address)

The address of the message sender.

`recipient`: [`Address!`](/docs/reference/scalars/#address)

The recipient of the message.

`nonce`: [`Nonce!`](/docs/reference/scalars/#nonce)

The nonce value for the message.

`data`: `[Int!]!`

The vector with the message data.

`daHeight`: [`U64!`](/docs/reference/scalars/#u64)

The block height of the data availability layer up to which (inclusive) input messages are processed.

## `MessageCoin`

Information about message coin

**fields:**

`sender`: [`Address!`](/docs/reference/scalars/#address)

The address of the message sender.

`recipient`: [`Address!`](/docs/reference/scalars/#address)

The recipient of the message.

`nonce`: [`Nonce!`](/docs/reference/scalars/#nonce)

The nonce value for the message.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount of base asset coins sent with the message.

`assetId`: [`AssetId`](/docs/reference/scalars/#assetid)

The asset id of the coins transferred.

`daHeight`: [`U64!`](/docs/reference/scalars/#u64)

The block height of the data availability layer up to which (inclusive) input messages are processed.

## `MessageProof`

Information about the message proof.

**fields:**

`messageProof`: [`MerkleProof!`](#merkleproof)

The merkle proof of the message.

`blockProof`: [`MerkleProof!`](#merkleproof)

The merkle proof of the block.

`messageBlockHeader`: [`Header!`](#header)

The merkle proof of the message.

`commitBlockHeader`: [`Header!`](#header)

The merkle proof of the block.

`sender`: [`Address!`](/docs/reference/scalars/#address)

The message sender.

`recipient`: [`Address!`](/docs/reference/scalars/#address)

The message recipient.

`nonce`: [`Nonce!`](/docs/reference/scalars/#nonce)

The message nonce.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount sent in the message.

`data`: [`HexString!`](/docs/reference/scalars/#hexstring)

The data from the message.

## `MessageStatus`

The status type of a message.

**fields:**

`state`: [`MessageState`](/docs/reference/enums/#messagestate)

The state of the message.

## `NodeInfo`

Information about a node.

**fields:**

`utxoValidation`: `Boolean!`

Whether or not the node is using UTXO validation.

`vmBacktrace`: `Boolean!`

Whether or not logging of backtraces from VM errors is enabled.

`maxTx`: [`U64!`](/docs/reference/scalars/#u64)

The maximum number of transactions.

`maxDepth`: [`U64!`](/docs/reference/scalars/#u64)

The maximum number of connected UTXOs allowed, excluding contracts.

`nodeVersion`: `String!`

The node version.

`peers`: [`PeerInfo!`](#peerinfo)!`

The information about the node's peers.

## `OutputBreakpoint`

A breakpoint during debugging.

**fields:**

`contract`: [`ContractId!`](/docs/reference/scalars/#contractid)

The contract address.

`pc`: [`U64!`](/docs/reference/scalars/#u64)

The value of the program counter register `$pc`, which is the memory address of the current instruction.

## `PeerInfo`

Information about a peer node.

**fields:**

`id`: `String!`

The `libp2p` ID of the peer node.

`addresses`: `[String!]!`

The advertised addresses that can be used to connect to this peer node.

`clientVersion`: `String`

The self-reported version of the client the peer node is using.

`blockHeight`: [`U32`](/docs/reference/scalars/#u32)

The last reported height of the peer node.

`lastHeartbeatMs`: [`U64!`](/docs/reference/scalars/#u64)

The time of the last heartbeat from this peer node in Unix epoch time milliseconds.

`appScore`: `Float!`

The internal Fuel peer-to-peer reputation of this peer node.

## `PoAConsensus`

The proof-of-authority (PoA) consensus type.

**fields:**

`signature`: [`Signature!`](/docs/reference/scalars/#signature)

The signature of the block produced by PoA consensus.

## `ProgramState`

An object representing the state of execution of a transaction.

**fields:**

`returnType`: [`ReturnType!`](/docs/reference/enums/#returntype)

The type of return response for the transaction.

`data`: [`HexString!`](/docs/reference/scalars/#hexstring)

The data returned from the transaction.

## `Policies`

Information about the policies of a transaction.

**fields:**

`tip`: [`U64`](/docs/reference/scalars/#u64)

The user-defined `tip` is a new transaction policy that replaced the `GasPrice` transaction policy. `Tip` allows the user to specify how much they want to pay to the block producer to incentivize them to include the user's transaction in the block.

`witnessLimit`: [`U64`](/docs/reference/scalars/#u64)

The limit of witnesses that can be included in the transaction.

`maturity`: [`U32`](/docs/reference/scalars/#u32)

The minimum block height that the transaction can be included at.

`maxFee`: [`U64`](/docs/reference/scalars/#u64)

The maximum fee allowed for the transaction to consume.

## `PredicateParameters`

The consensus parameters for predicates.

**fields:**

`version`: [`PredicateParametersVersion!`](/docs/reference/unions/#predicateparametersversion)

The version of the consensus parameters.

`maxPredicateLength`: [`U64!`](/docs/reference/scalars/#u64)

The maximum length of a predicate.

`maxPredicateDataLength`: [`U64!`](/docs/reference/scalars/#u64)

The maximum length of predicate data.

`maxGasPerPredicate`: [`U64!`](/docs/reference/scalars/#u64)

The maximum amount of gas allowed for a predicate.

`maxMessageDataLength`: [`U64!`](/docs/reference/scalars/#u64)

The maximum length of message data for a predicate.

## `Receipt`

An object representing all possible types of receipts.

**fields:**

`id`: [`ContractId!`](/docs/reference/scalars/#contractid)

The ID of the contract that produced the receipt.

`pc`: [`U64`](/docs/reference/scalars/#u64)

The value of the program counter register `$pc`, which is the memory address of the current instruction.

`is`: [`U64`](/docs/reference/scalars/#u64)

The value of register `$is`, which is the pointer to the start of the currently-executing code.

`to`: [`Contract`](#contract)

The recipient contract.

`toAddress`: [`Address`](/docs/reference/scalars/#address)

The recipient address.

`amount`: [`U64`](/docs/reference/scalars/#u64)

The amount of coins transferred.

`assetId`: [`AssetId`](/docs/reference/scalars/#assetid)

The asset id of the coins transferred.

`gas`: [`U64`](/docs/reference/scalars/#u64)

The gas used for the transaction.

`param1`: [`U64`](/docs/reference/scalars/#u64)

The first parameter for a `CALL` receipt type, holds the function selector.

`param2`: [`U64`](/docs/reference/scalars/#u64)

The second parameter for a `CALL` receipt type, typically used for the user-specified input to the ABI function being selected.

`val`: [`U64`](/docs/reference/scalars/#u64)

The value of registers at the end of execution, used for debugging.

`ptr`: [`U64`](/docs/reference/scalars/#u64)

The value of the pointer register, used for debugging.

`digest`: [`Bytes32`](/docs/reference/scalars/#bytes32)

A 32-byte hash of `MEM[$rC, $rD]`. The syntax `MEM[x, y]` means the memory range starting at byte `x`, of length `y` bytes.

`reason`: [`U64`](/docs/reference/scalars/#u64)

The decimal string representation of an 8-bit unsigned integer for the panic reason. Only returned if the receipt type is `PANIC`.

`ra`: [`U64`](/docs/reference/scalars/#u64)

The value of register `$rA`.

`rb`: [`U64`](/docs/reference/scalars/#u64)

The value of register `$rB`.

`rc`: [`U64`](/docs/reference/scalars/#u64)

The value of register `$rC`.

`rd`: [`U64`](/docs/reference/scalars/#u64)

The value of register `$rD`.

`len`: [`U64`](/docs/reference/scalars/#u64)

The length of the receipt.

`receiptType`: [`ReceiptType!`](/docs/reference/enums/#receipttype)

The type of receipt.

`result`: [`U64`](/docs/reference/scalars/#u64)

`0` if script exited successfully, `any` otherwise.

`gasUsed`: [`U64`](/docs/reference/scalars/#u64)

The amount of gas consumed by the script.

`data`: [`HexString`](/docs/reference/scalars/#hexstring)

The receipt data.

`sender`: [`Address`](/docs/reference/scalars/#address)

The address of the message sender.

`recipient`: [`Address`](/docs/reference/scalars/#address)

The address of the message recipient.

`nonce`: [`Nonce`](/docs/reference/scalars/#nonce)

The nonce value for a message.

`contractId`: [`ContractId`](/docs/reference/scalars/#contractid)

The contract id.

`subId`: [`Bytes32`](/docs/reference/scalars/#bytes32)

The sub id.

## `RelayedTransactionFailed`

Details about why a relayed transaction from an L1 failed.

**fields:**

`blockHeight`: `U32!`

The block height at the time the relayed transaction failed.

`failure`: `String!`

The reason why the transaction failed.

## `RunResult`

The result of a transaction execution.

**fields:**

`state`: `RunState!`

The state of the transaction execution.

`breakpoint`: `OutputBreakpoint`

A breakpoint during debugging.

`jsonReceipts`: `[String!]!`

The receipts of the transaction in JSON format.

## `ScriptParameters`

The consensus parameters for a script.

**fields:**

`version`: [`ScriptParametersVersion!`](/docs/reference/unions/#scriptparametersversion)

The version of the consensus parameters.

`maxScriptLength`: [`U64!`](/docs/reference/scalars/#u64)

The maximum length of a script.

`maxScriptDataLength`: [`U64!`](/docs/reference/scalars/#u64)

The maximum length of script data.

## `SpendQueryElementInput`

A type used in the `queryPerAsset` argument for the `resourcesToSpend` query.

**fields:**

`assetId`: [`AssetId!`](/docs/reference/scalars/#assetid)

The asset id for the asset.

`amount`: [`U64!`](/docs/reference/scalars/#u64)

The amount of coins to send.

`max`: [`U64`](/docs/reference/scalars/#u64)

The max number of resources in the selection.

## `SqueezedOutStatus`

The status for a transaction that was squeezed out of the transaction pool.

**fields:**

`reason`: `String!`

The reason why the transaction was squeezed out.

## `StateTransitionBytecode`

The bytecode of a state transition upgrade.

**fields:**

`root`: [`[HexString!]`](/docs/reference/scalars/#hexstring)

The merkle root of the state transition bytecode.

`bytecode`: [`[UploadedBytecode!]`](#uploadedbytecode)

The bytecode of the state transition.

## `StateTransitionPurpose`

Details about a state transition upgrade.

**fields:**

`root`: [`Bytes32!`](/docs/reference/scalars/#bytes32)

The merkle root of the new state.

## `SuccessStatus`

The status of a successful transaction.

**fields:**

`transactionId`: [`TransactionId!`](/docs/reference/scalars/#transactionid)

The ID of the transaction.

`blockHeight`: [`U32`](/docs/reference/scalars/#u32)

The block height for the successful transaction.

`block`: [`Block!`](#block)

The block for the successful transaction.

`transaction`: [`Transaction!`](#transaction)

The transaction itself.

`time`: [`Tai64Timestamp!`](/docs/reference/scalars/#tai64timestamp)

The time of the transaction.

`programState`: [`ProgramState`](#programstate)

The state of the program execution.

`receipts`: [`[Receipt!]!`](#receipt)

The transaction receipts.

`totalGas`: [`U64!`](/docs/reference/scalars/#u64)

The total amount of gas used.

`totalFee`: [`U64!`](/docs/reference/scalars/#u64)

The total fee for the transaction.

## `SubmittedStatus`

The status for a submitted transaction.

**fields:**

`time`: [`Tai64Timestamp!`](/docs/reference/scalars/#tai64timestamp)

The time a transaction was submitted

## `Transaction`

An object containing information about a transaction.

**fields:**

`id`: [`TransactionId!`](/docs/reference/scalars/#transactionid)

A unique transaction id.

`inputAssetIds`: [`[AssetId!]`](/docs/reference/scalars/#assetid)

An array of asset ids used for the transaction inputs.

`inputContracts`: [`[Contract!]`](#contract)

An array of contracts used for the transaction inputs.

`inputContract`: [`InputContract`](#inputcontract)

A contract used for the transaction input.

`policies`: [`Policies`](#policies)

The policies for the transaction.

`scriptGasLimit`: [`U64`](/docs/reference/scalars/#u64)

The gas limit for the transaction.

`maturity`: [`U32`](/docs/reference/scalars/#u32)

The minimum block height that the transaction can be included at.

`mintAmount`: [`U64`](/docs/reference/scalars/#u64)

The amount minted in the transaction.

`mintAssetId`: [`AssetId`](/docs/reference/scalars/#assetid)

The asset ID for coins minted in the transaction.

`mintGasPrice`: [`U64!`](/docs/reference/scalars/#u64)

The gas price at the time of minting the block.

`txPointer`: [`TxPointer`](/docs/reference/scalars/#txpointer)

The location of the transaction in the block.

`isScript`: `Boolean!`

Whether or not the transaction is a script.

`isCreate`: `Boolean!`

Whether or not the transaction is creating a new contract.

`isMint`: `Boolean!`

Whether or not the transaction is minting new coins.

`isUpgrade`: `Boolean!`

Whether or not the transaction is upgrading the network.

`isUpload`: `Boolean!`

Whether or not the transaction is uploading state transition data to prepare for upgrading the network.

`isBlob`: `Boolean!`

Whether or not the transaction is a blob.

`inputs`: [`[Input!]`](/docs/reference/unions/#input)

An array of inputs for the transaction.

`outputs`: [`[Output!]!`](/docs/reference/unions/#output)

An array of outputs for the transaction.

`outputContract`: [`ContractOutput`](#contractoutput)

The contract output for the transaction.

`witnesses`: [`[HexString!]`](/docs/reference/scalars/#hexstring)

An array of witnesses.

`receiptsRoot`: [`Bytes32`](/docs/reference/scalars/#bytes32)

The root of the receipts.

`status`: [`TransactionStatus`](/docs/reference/unions/#transactionstatus)

The status of the transaction.

`script`: [`HexString`](/docs/reference/scalars/#hexstring)

The script to execute.

`scriptData`: [`HexString`](/docs/reference/scalars/#hexstring)

The script input parameters.

`bytecodeWitnessIndex`: `Int`

The witness index of contract bytecode.

`blobId`: [`BlobId`](/docs/reference/scalars/#blobid)

A unique hash identifier for a blob transaction.

`salt`: [`Salt`](/docs/reference/scalars/#salt)

The salt value for the transaction.

`storageSlots`: [`[HexString!]`](/docs/reference/scalars/#hexstring)

An array of storage slot.

`bytecodeRoot`: [`Bytes32`](/docs/reference/scalars/#bytes32)

The Merkle tree root of the bytecode that is being uploaded.

`subsectionIndex`: [`U16`](/docs/reference/scalars/#u16)

The index of the subsection of the bytecode.

`subsectionsNumber`: [`U16`](/docs/reference/scalars/#u16)

The total number of subsections that the bytecode was divided into.

`proofSet`: [`[Bytes32!]`](/docs/reference/scalars/#bytes32)

The proof set helps to verify the connection of the subsection to the `root`.

`upgradePurpose`: [`UpgradePurpose`](/docs/reference/unions/#upgradepurpose)

The purpose of a network upgrade.

`rawPayload`: [`HexString!`](/docs/reference/scalars/#hexstring)

A hex string of the raw transaction payload.

## `TxParameters`

The consensus parameters for a transaction.

**fields:**

`version`: [`TxParametersVersion!`](/docs/reference/unions/#txparametersversion)

The version of the consensus parameters.

`maxInputs`: [`U8!`](/docs/reference/scalars/#u8)

The maximum number of inputs allowed for a transaction.

`maxOutputs`: [`U8!`](/docs/reference/scalars/#u8)

The maximum number of outputs allowed for a transaction.

`maxWitnesses`: [`U32!`](/docs/reference/scalars/#u32)

The maximum number of witnesses allowed for a transaction.

`maxGasPerTx`: [`U64!`](/docs/reference/scalars/#u64)

The maximum amount of gas allowed for a transaction.

`maxSize`: [`U64!`](/docs/reference/scalars/#u64)

The maximum size allowed for a transaction.

`maxBytecodeSubsections`: [`U16!`](/docs/reference/scalars/#u16)

The maximum number of subsections the new executor bytecode can be broken into.

## `UploadedBytecode`

**fields:**

`bytecode`: [`[HexString!]!`](/docs/reference/scalars/#hexstring)

The bytecode that is uploaded.

`uploadedSubsectionsNumber`: `Int`

The number of uploaded subsections.

`completed`: `Boolean!`

Whether or not the bytecode upload has completed.

## `VariableOutput`

The output type for a transaction that outputs an amount that may vary based on transaction execution.

**fields:**

`to`: [`Address`](/docs/reference/scalars/#address)

The address the coins were sent to.

`amount`: [`U64`](/docs/reference/scalars/#u64)

The amount of coins in the output.

`assetId`: [`AssetId`](/docs/reference/scalars/#assetid)

The asset id for the coins sent.
