
# Subscriptions

## `statusChange`

Returns a stream of [`TransactionStatus!`](/docs/reference/unions/#transactionstatus) updates for the given transaction id if the current status is `[TransactionStatus::Submitted]`.

This stream will wait forever so it's advised to use within a timeout. It is possible for the stream to miss an update if it is polled slower then the updates arrive. In such a case the stream will close without a status. If this occurs the stream can simply be restarted to return the latest status.

**args:**

`id`: [`TransactionId!`](/docs/reference/scalars/#transactionid)

The id of the transaction to stream status updates for.

## `submitAndAwait`

Submits a transaction to the `TxPool` and await returns the [`TransactionStatus!`](/docs/reference/unions/#transactionstatus).

**args:**

`tx`: [`HexString!`](/docs/reference/scalars/#hexstring)

The transaction hex string.

## `submitAndAwaitStatus`

Submits the transaction to the `TxPool` and returns a stream of events. Compared to the [`submitAndAwait`](/docs/reference/subscriptions/#submitandawait), the stream also contains [`SubmittedStatus`](/docs/reference/objects/#submittedstatus) as an intermediate state.

**args:**

`tx`: [`HexString!`](/docs/reference/scalars/#hexstring)

The transaction hex string.
