# How to Stake on Mainnet Ethereum

Please visit [app.fuel.network/staking/on-ethereum](https://app.fuel.network/staking/on-ethereum) to stake your tokens on the Fuel Shared Sequencer Network from Ethereum. Below is a help guide:

## Connect EVM Wallet

Start by connecting an Ethereum wallet with FUEL tokens, whether they are already in the shared sequencer network or in your mainnet wallet.

![Connect EVM Wallet](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/1-connect-evm-wallet.png)

## Stake

From left to right, you can see your balance of FUEL tokens in your Ethereum wallet, your balance of FUEL tokens in the shared sequencer network, and the rewards accumulated.

Please note that tokens still in your mainnet Ethereum wallet must be migrated to the shared sequencer network first before you can delegate and stake. Don’t worry, as this will follow the same flow.

![Token Balances](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/2-token-balances.png)

### Select Validator

Scroll down to the bottom of the page. There, you will see a list of validators. From the list, choose the validator to which you want to stake and delegate your FUEL tokens. Click the "Deposit" button.

![Select Validator](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/3-select-validator.png)

### Delegating Tokens

Select the amount of FUEL tokens you want to delegate, and approve those tokens.

![Delegate Tokens](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/4-delegation-amount.png)

Once approved, confirm your delegation.

![Open Positions](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/5-confirm-delegation.png)

After the tokens have been successfully delegated and staked, you will see your tokens under "Delegated Positions."

![Open Positions](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/5.5-open-delegated-positions.png)

## Claim Rewards

After staking your FUEL tokens, you will immediately start to accumulate FUEL rewards, which you can claim. Click "Claim" on any of your open delegated positions to collect your rewards.

![Claim Rewards](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/6-claim-rewards.png)

Your rewards will be added to your balance in the Fuel shared sequencer network.

![Claim Rewards Pt2](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/7-claim-rewards-pt2.png)

## Withdrawal

You can undelegate and withdraw your staked FUEL tokens at any time. However, there is a standard 14-day unbonding period before the undelegation is completed, ensuring economic security within the PoS shared sequencer network and the Ethereum mainnet. After the 14-day period, the withdrawal process requires 4096 sequencer blocks approximately seven more hours before your tokens become available in your mainnet Ethereum wallet.

### Undelegate

To undelegate your open positions, simply press the hamburger button beside your position and click the "Undelegate" button.

![Withdrawal](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/8-undelegate.png)

Here, you can select how many delegated tokens you wish to undelegate. These tokens will return to your balance in the shared sequencer network.

![Withdrawal Pt2](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/9-undelegate-pt2.png)

### Withdraw Balance in Sequencer

Lastly, you can withdraw your tokens from the shared sequencer network back to your mainnet Ethereum wallet by clicking the "Withdraw" button beside your balance in the shared sequencer.

![Withdrawal](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/10-withdrawal.png)

Here you can specify how many tokens you want to withdraw.

![Withdrawal Pt2](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-stake-mainnet-ethereum/10.5-withdrawal-pt2.png)
