# Tokenomics

With the introduction of FUEL and its total initial supply of 10 billion tokens, we aim to create a level playing field that ensures fair access for both existing members and newcomers to our growing ecosystem. To acknowledge and reward our long-standing friends, builders, and users, 20% of the initial supply will be distributed to the community, with eligibility determined by factors such as participation in the Fuel Points Program and our incentivized testnet. In total, over 51% of all FUEL tokens will ultimately be allocated to the community, the broader ecosystem, and ongoing research and development efforts, reflecting our commitment to inclusivity and shared growth.

![Allocation Pie Chart](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/tokenomics/1-pie.png)

| Group                | Details                                                                                                                                                                                                    | Amount       |
|----------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------|
| Community Expansion  | Used for incentives, programs, campaigns and activations for the Fuel community and expansion.                                                                                                             | 2.00 billion |
| Ecosystem and R&D    | Used to establish the sequencing network, and for ecosystem development and Fuel technology R&D.                                                                                                           | 1.55 billion |
| Ecosystem and R&D 24 | Same as above. These locked tokens can be staked during the 24 month block-by-block linear release. Staking rewards will only be used for ecosystem development efforts and to enable L2 level incentives. | 1.55 billion |
| Contributors 24      | Includes past and present Fuel contributors.                                                                                                                                                               | 0.60 billion |
| Contributors 48      | Core project contributors.                                                                                                                                                                                 | 0.98 billion |
| Purchasers           | Token purchasers from 2020 to 2022.                                                                                                                                                                        | 3.31 billion |

## Inflation

Inflation will be 3% annually. Note that inflation and Fuel economics are configured by the sequencer validator set.

## Unlocks

Note: Team and Purchasers can't stake locked tokens.

![Release Schedule](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/tokenomics/2-release-schedule.png)

| Group                | Details                                                                                                                                                                                                    | Vesting Schedule        |
|----------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------|
| Community            | Used for incentives, programs, campaigns and activations for the Fuel community and expansion.                                                                                                             | Immediate               |
| Ecosystem and R&D    | Used to establish the sequencing network, and for ecosystem development and Fuel technology R&D.                                                                                                           | Immediate               |
| Ecosystem and R&D 24 | Same as above. These locked tokens can be staked during the 24 month block-by-block linear release. Staking rewards will only be used for ecosystem development efforts and to enable L2 level incentives. | 24 month linear release |
| Contributors 24      | Includes past and present Fuel contributors.                                                                                                                                                               | 24 month linear release |
| Contributors 48      | Core project contributors.                                                                                                                                                                                 | 48 month linear release |
| Purchasers           | Token purchasers from 2020 to 2022.                                                                                                                                                                        | 24 month linear release |
