# Test Node Options

This reference describes all the options of the [`launchTestNode`](./launching-a-test-node.md) utility:

- [`walletsConfig`](./test-node-options.md#walletsconfig)
- [`contractsConfigs`](./test-node-options.md#contractsconfigs)
- [`nodeOptions`](./test-node-options.md#nodeoptions)
- [`providerOptions`](./test-node-options.md#provideroptions)

```
const customLaunchTestNode = await launchTestNode(/* options */);
```

Check out the [API reference](DOCS_API_URL/interfaces/_fuel_ts_contract.test_utils.LaunchTestNodeOptions.html) for usage information on the Test Node Options.

## `walletsConfig`

Used to set the node's genesis block state (coins and messages).

- `count`: number of wallets/addresses to generate on the genesis block.
- `assets`: configure how many unique assets each wallet will own with the base asset included. Can be `number` or `TestAssetId[]`.
  - The `TestAssetId` utility simplifies testing when different assets are necessary.
- `coinsPerAsset`: number of coins (UTXOs) per asset id.
- `amountPerCoin`: for each coin, the amount it'll contain.
- `messages`: messages to assign to the wallets.

### `walletsConfig.assets`

The `TestAssetId` utility integrates with [`walletsConfig`](./test-node-options.md#walletsconfig) and gives you an easy way to generate multiple random asset ids via the `TestAssetId.random` static method.

```
const randomAssetIds = TestAssetId.random();

const nodeWithCustomAssetIds = await launchTestNode({
  walletsConfig: {
    assets: randomAssetIds,
  },
});

const {
  wallets: [walletWithCustomAssetIds],
} = nodeWithCustomAssetIds;

const { coins } = await walletWithCustomAssetIds.getCoins(
  randomAssetIds[0].value
);
```

### `walletsConfig.messages`

The `TestMessage` helper class is used to create messages for testing purposes. When passed via `walletsConfig.messages`, the `recipient` field of the message is overriden to be the wallet's address.

```
const testMessage = new TestMessage({ amount: 1000 });

const nodeWithTestMessages = await launchTestNode({
  walletsConfig: {
    messages: [testMessage],
  },
});

const {
  wallets: [walletWithTestMessages],
} = nodeWithTestMessages;

const {
  messages: [messageWithTestMessages],
} = await walletWithTestMessages.getMessages();
```

It can also be used standalone and passed into the initial state of the chain via the `TestMessage.toChainMessage` instance method.

```
const recipient = WalletUnlocked.generate();
const testMessageOnChain = new TestMessage({
  amount: 1000,
  recipient: recipient.address,
});

using launchedWithTestMessagesOnChain = await launchTestNode({
  nodeOptions: {
    snapshotConfig: {
      stateConfig: {
        messages: [testMessageOnChain.toChainMessage()],
      },
    },
  },
});

const { provider: providerWithTestMessagesOnChain } =
  launchedWithTestMessagesOnChain;

recipient.provider = providerWithTestMessagesOnChain;

const {
  messages: [messageOnChain],
} = await recipient.getMessages();
```

## `contractsConfigs`

Used to deploy contracts on the node the `launchTestNode` utility launches. It's an array of objects with the following properties:

- `factory`: contract factory class outputted by `pnpm fuels typegen`.
- `walletIndex`: the index of the wallets generated by [`walletsConfig`](./test-node-options.md#walletsconfig) that you want to deploy the contract with.
- `options`: options for [contract deployment](../contracts/deploying-contracts.md#2-contract-deployment) that get passed to the [`ContractFactory.deploy`](DOCS_API_URL/classes/_fuel_ts_contract.index.ContractFactory.html#deploy) method.

## `nodeOptions`

<!-- TODO: will cross-reference work done in [#1915](https://github.com/FuelLabs/fuels-ts/issues/1915) -->

Options to modify the behavior of the node.

For example, you can specify your own base asset id of the chain like below:

```
const [baseAssetId] = TestAssetId.random();

const nodeWithCustomBaseAssetId = await launchTestNode({
  nodeOptions: {
    snapshotConfig: {
      chainConfig: {
        consensus_parameters: {
          V2: {
            base_asset_id: baseAssetId.value,
          },
        },
      },
    },
  },
});
```

_Note: The API for these options is still not fully complete and better documentation will come in the future._

## `providerOptions`

Provider options passed on `Provider` instantiation. More on them [here](../provider/provider-options.md).
