# `B256`

The type `B256` in Fuel represents hashes and holds a 256-bit (32-bytes) value. The TypeScript SDK represents `B256` as a hexlified string value for portability and provides utilities to convert to `Uint8Array` when the [raw bytes](./bytes32.md) are required.

## Generating random `B256` values

To generate a random `B256` value, you can use the `getRandomB256()` function:

```
import { getRandomB256 } from 'fuels';

// b256 is a hexlified string representing a 256-bit value
const b256: string = getRandomB256();

console.log('b256', b256);
// 0xbebd3baab326f895289ecbd4210cf886ce41952316441ae4cac35f00f0e882a6
```

### Converting between `B256` and `Uint8Array`

To convert between a `B256` hexlified string and a `Uint8Array`, you can use the `arrayify` and `hexlify` functions:

```
import { arrayify, getRandomB256, hexlify } from 'fuels';

const randomB256: string = getRandomB256();

// Convert to Uint8Array
const uint8Arr: Uint8Array = arrayify(randomB256);

// Convert back to hexlified string
const hexedB256: string = hexlify(uint8Arr);
```

## Support from `Address` Class

A `B256` value is also supported as part of the [`Address`](https://fuels-ts-docs-api.vercel.app/classes/_fuel_ts_address.Address.html) class, providing seamless integration with other components of your application. To create an [`Address`](https://fuels-ts-docs-api.vercel.app/classes/_fuel_ts_address.Address.html) instance from a b256 value, use the `new Address()` method:

```
import { getRandomB256, Address } from 'fuels';

const randomB256: string = getRandomB256();

const address = new Address(randomB256);
```
