# Types

As you dive deeper into the SDK, it's essential to understand the variety of internal types available in both FuelVM and Sway, as well as their corresponding SDK equivalents. This section aims to provide you with the necessary knowledge to efficiently work with these types.

## Overview

In this section, you will learn about:

1. `FuelVM and Sway Internal Types`: Discover the various types used within FuelVM and Sway, and their significance in different contexts.

2. `SDK Equivalents`: Explore the corresponding types available in the SDK, and understand their similarities and differences compared to FuelVM and Sway internal types.

3. `Type Usage`: Gain insights into how to effectively use these types in your projects or applications, with examples and best practices.

4. `Type Conversion`: Learn the techniques and methods for converting between FuelVM, Sway, and SDK types, guaranteeing smooth interoperability and consistent data integrity.

## Additional Resources

As you progress through the documentation, you may find it helpful to refer back to the following resources:

- [Sway Documentation](https://docs.fuel.network/docs/sway/): Explore the Sway documentation homepage for an overview of Sway Types, as well as other sections.

- [The Fuel Book](https://fuelbook.fuel.network/master/index.html): A comprehensive guide to the whole Fuel ecosystem.
