# What is Fuel?

Fuel is an operating system purpose built for Ethereum Rollups.
Fuel allows rollups to solve for PSI (parallelization, state minimized execution, interoperability) without making any sacrifices.

Here is how we do it:

## FuelVM

The FuelVM learns from the Ethereum ecosystem.
It implements improvements suggested to the Ethereum VM (EVM) for many years that couldn’t be implemented due to the need to maintain backward compatibility, including parallel transaction execution and multiple native assets.

Fuel delivers unmatched processing capacity through its ability to execute transactions in parallel by using strict state access lists in the form of a UTXO model.
With the FuelVM, Fuel full nodes identify the accounts a transaction touches, mapping out dependencies before execution.
This enables Fuel to use far more threads and cores of your CPU that are typically idle in single-threaded blockchains.
As a result, Fuel can deliver far more compute, state accesses, and transactional throughput than its single-threaded counterparts.

## Sway Language

Fuel provides a powerful and sleek developer experience with our own domain-specific language (DSL) called Sway.
Sway is based on Rust and includes syntax to leverage a blockchain VM without needlessly verbose boilerplate.
Sway was created alongside the FuelVM and designed for the high-compute Fuel environment.

### Rust + Solidity = Sway

Sway prioritizes compile-time analysis and safety, similar to Rust’s borrow checker and safety-first semantics.
Additionally, it has the syntax of Rust. From Solidity, Sway took the notion of a smart-contract-paradigm language with built-in top-level contract storage and blockchain mechanisms for ergonomic and safe contract programming.

Sway brings the notion of static auditing to smart contracts.
In addition, Sway is highly performant and has extensible optimization passes and a modular backend for targeting different blockchain architectures.

<CardSection
versionSet={props.versionSet}
cardsInfo={[
    {
        link: '/docs/sway',
        nightlyLink: '/docs/nightly/sway',
        isExternal: false,
        heading: 'Sway',
        headingIcon: 'Code',
        body: 'Read the official Sway documentation.',
    },
    {
        link: 'https://sway-playground.org/',
        isExternal: true,
        heading: 'Sway Playground',
        headingIcon: 'Browser',
        body: 'Get started experimenting with Sway in the browser.',
    },
    {
        link: 'https://swaybyexample.com/',
        isExternal: true,
        heading: 'Sway By Example',
        headingIcon: 'Beach',
        body: 'An introduction to Sway with bite-sized simple examples',
    },
    {
        link: 'https://github.com/FuelLabs/sway-examples',
        isExternal: true,
        heading: 'Sway Examples',
        headingIcon: 'Robot',
        body: 'Examples of full-stack DeFi applications',
    },
    {
        link: '/docs/sway-libs',
        nightlyLink: '/docs/nightly/sway-libs',
        isExternal: false,
        heading: 'Sway Libraries',
        headingIcon: 'Book',
        body: 'Find useful libraries written in Sway.',
    },
    {
        link: '/docs/sway-standards',
        nightlyLink: '/docs/nightly/sway-standards',
        isExternal: false,
        heading: 'Sway Standards',
        headingIcon: 'Book',
        body: 'Learn about standards for the Sway language',
    },
    {
        link: 'https://fuellabs.github.io/sway/master/std/',
        isExternal: true,
        heading: 'std-lib Reference',
        headingIcon: 'Book',
        body: 'Find definitions for helpful types and methods in Sway.',
    },
    {
        link: 'https://github.com/FuelLabs/sway-applications',
        isExternal: true,
        heading: 'Example Applications',
        headingIcon: 'Apps',
        body: 'Explore end-to-end applications written in Sway.',
    },
]}
/>

## Developer Tooling

Part of what makes Sway so powerful is the fantastic suite of developer tools surrounding it.
The Fuel development environment retains the benefits of smart contract languages like Solidity, while adopting the paradigms introduced in the Rust tooling ecosystem.

Now, developers can have a completely vertically integrated experience where every component, from the virtual machine to the CLI, works in harmony.

### Sway Tooling

<CardSection
versionSet={props.versionSet}
cardsInfo={[
     {
        link: '/docs/forc',
        nightlyLink:'/docs/nightly/forc',
        isExternal: false,
        heading: 'Forc',
        headingIcon: 'Tool',
        body: 'Explore the Fuel Orchestrator that helps you build, test, and deploy your Sway projects.',
    },
    {
        link: '/guides/installation/',
        nightlyLink: '/guides/installation/',
        isExternal: false,
        heading: 'Fuelup',
        headingIcon: 'Settings',
        body: 'Learn more about the official Fuel toolchain manager that helps install and manage versions.',
    }
]}
/>

### SDKs & API

<CardSection
versionSet={props.versionSet}
cardsInfo={[
{
          link: '/docs/fuels-rs',
          nightlyLink: '/docs/nightly/fuels-rs',
          isExternal: false,
          heading: 'Rust SDK',
          headingIcon: 'BrandRust',
          body: 'Test and interact with your Sway program in Rust.',
        },
        {
          link: '/docs/fuels-ts',
          nightlyLink: '/docs/nightly/fuels-ts',
          isExternal: false,
          heading: 'Typescript SDK',
          headingIcon: 'BrandTypescript',
          body: 'Test and interact with your Sway program in TypeScript.',
        },
        {
          link: '/docs/wallet',
          nightlyLink: '/docs/nightly/wallet',
          isExternal: false,
          heading: 'Wallet SDK',
          headingIcon: 'Wallet',
          body: 'Seamlessly integrate a wallet into your application.',
        },
        {
         link: '/docs/graphql',
          nightlyLink: '/docs/nightly/graphql',
          isExternal: false,
          heading: 'GraphQL API',
          headingIcon: 'ChartDots3',
          body: 'Learn about the GraphQL API and interact with the Fuel Network.',
        },
]}
/>

### Network

<CardSection
versionSet={props.versionSet}
cardsInfo={[
    {
        link: `/docs/specs`,
        nightlyLink: `/docs/nightly/specs`,
        isExternal: false,
        heading: 'Specs',
        headingIcon: 'ListDetails',
        body: 'Explore the specifications for the Fuel Network.',
    },
    {
        link: props.explorerUrl,
        isExternal: true,
        heading: 'Explorer',
        headingIcon: 'Search',
        body: 'Explore transactions on the Fuel network.',
    },
    {
        link: props.bridgeUrl,
        isExternal: true,
        heading: 'Bridge',
        headingIcon: 'BuildingBridge',
        body: 'Bridge assets to the Fuel network.',
    },
        {
        link: props.faucetUrl,
        isExternal: true,
        heading: 'Faucet',
        headingIcon: 'Coin',
        body: `Get ${props.fuelTestnet} testnet tokens.`,
    }
]}
/>
