
# Scalars

## `Address`

An address of an externally owned account identified by a 32 byte string prefixed by `0x`.

## `AssetId`

A 32 byte unique ID used to identify a coin. On the testnet, the `assetId` is `0x0000000000000000000000000000000000000000000000000000000000000000`.

## `BlobId`

A unique hash identifier for a blob transaction.

## `BlockId`

A unique hash identifier for a block.

## `Bytes32`

32 bytes to hold arbitrary data, usually as a hex string. `Bytes32` is the base type for cryptographic primitives like `Address` or `Message`.

## `ContractId`

A wrapped 32byte hash that is used to uniquely identify a contract.

## `HexString`

A way to pass in bytes as hex data. This is used for variable byte length types. Predicates and predicate data are always a hex string.

## `Nonce`

A random or pseudo-random number generated for a single use to ensure data freshness and prevent replay attacks.

## `RelayedTransactionId`

The ID for a relayed transaction.

## `Salt`

Sometimes referred to as a nonce. A unique, random value used to distinguish two things that are otherwise identical. This is used in contract deployments so you can deploy contracts that are otherwise exactly the same.

## `Signature`

A cryptographic signature used to authorize messages and transactions.

## `Tai64Timestamp`

A TAI 64 timestamp.

## `TransactionId`

A unique 32 byte hash identifier for a transaction.

## `TxPointer`

The location of the transaction in the block. It can be used by UTXOs as a reference to the transaction or by the transaction itself to make it unique.

## `U16`

Unsigned 16 bit integer.

## `U32`

Unsigned 32 bit integer.

## `U64`

Unsigned 64 bit integer. The default GraphQL `int` scalar does not cover the range of values needed because the FuelVM word size is 64bit.

## `UtxoId`

A unique 32 byte identifier for a UTXO.
