
# Union Types

## `CoinType`

The type of coin being used.

**Types:**

[`Coin`](/docs/reference/objects/#coin): A standard coin.

[`MessageCoin`](/docs/reference/objects/#messagecoin): A message coin.

## `Consensus`

The type of consensus mechanism used to validate a block.

**Types:**

[`Genesis`](/docs/reference/objects/#genesis): Genesis consensus

[`PoAConsensus`](/docs/reference/objects/#poaconsensus): PoA
consensus

## `DependentCost`

Contains the dependent cost of opcodes.

**Types:**

[`LightOperation`](/docs/reference/objects/#lightoperation): Operations that can process many units with 1 gas

[`HeavyOperation`](/docs/reference/objects/#heavyoperation): Operations that require more than 1 gas to process a single unit

## `DryRunTransactionStatus`

The status of a transaction dry run.

**Types:**

[`DryRunSuccessStatus`](/docs/reference/objects/#dryrunsuccessstatus): The transaction dry run was successful.

[`DryRunFailureStatus`](/docs/reference/objects/#dryrunfailurestatus): The transaction dry run failed.

## `Input`

An input type for a transaction.

**Types:**

[`InputCoin`](/docs/reference/objects/#inputcoin): An input type for
a coin.

[`InputContract`](/docs/reference/objects/#inputcontract): An input
type for a contract.

[`InputMessage`](/docs/reference/objects/#inputmessage): An input
type for a message.

## `Output`

An output type for a transaction.

**Types:**

[`CoinOutput`](/docs/reference/objects/#coinoutput): Indicates coins
were forwarded from one address to another.
Can be used during transaction creation when the recipient, asset, and amount is known.

[`ContractOutput`](/docs/reference/objects/#contractoutput):
Indicates the transaction updated the state of a contract.

[`ChangeOutput`](/docs/reference/objects/#changeoutput): Indicates
that the output's amount may vary based on transaction execution, but is
otherwise identical to a Coin output. Output changes are always guaranteed to
have an amount of zero since they're only set after execution terminates.

[`VariableOutput`](/docs/reference/objects/#variableoutput): Similar
to `ChangeOutput`, this output type indicates that the output's amount may vary
based on transaction execution, but is otherwise identical to a Coin output. On
initialization, the amount on variable outputs is zero, but during execution
they could be set to a non-zero value.

[`ContractCreated`](/docs/reference/objects/#contractcreated):
Indicates a contract was deployed.

## `RelayedTransactionStatus`

The status of a relayed transaction from a L1. If the transaction is valid, it will be included in part of a block. If the transaction is invalid, it will be skipped.

**Types:**

[`RelayedTransactionFailed`](/docs/reference/objects/#relayedtransactionfailed): Details about why the relayed transaction failed.

## `TransactionStatus`

The status type of a transaction.

**Types:**

[`SubmittedStatus`](/docs/reference/objects/#submittedstatus): The transaction has been submitted.

[`SuccessStatus`](/docs/reference/objects/#successstatus): The transaction has succeeded.

[`SqueezedOutStatus`](/docs/reference/objects/#squeezedoutstatus): The transaction was kicked out of the mempool.

[`FailureStatus`](/docs/reference/objects/#failurestatus): The transaction has failed.

## `UpgradePurpose`

The purpose of a network upgrade.

**Types:**

[`ConsensusParametersPurpose`](/docs/reference/objects/#consensusparameterspurpose): The consensus parameters are being upgraded.

[`StateTransitionPurpose`](/docs/reference/objects/#statetransitionpurpose): The state transition is being upgraded.
