# How to Upgrade Fuel V1 to FUEL

> The Fuel V1 token was the previous iteration of the FUEL token. The initial supply of Fuel V1 tokens was 100 million. The supply of the current FUEL token is 10 billion. Fuel V1 tokens can accordingly be upgraded at a ratio of 1:100.

Please visit [app.fuel.network/upgrade](https://app.fuel.network/upgrade) to upgrade your Fuel V1 tokens to FUEL tokens. Below is a short help guide:

## Connecting an EVM Wallet

Fuel V1 grants exist only on the Ethereum mainnet. Please connect an EVM wallet with a token grant or Fuel V1 tokens using the button in the top-right corner.

![Connect EVM Wallet](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-upgrade-fuel-v1/1-connect-evm-wallet.png)

## Claiming a Token Grant

If you have a token grant, the amount of unclaimed tokens will be displayed, along with a button to claim the tokens into your wallet. If you already have Fuel V1 tokens ready to upgrade, you can skip this step.

![Claim Token Grant](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-upgrade-fuel-v1/2-claim-token-grant.png)

## Upgrade Fuel V1 Tokens to Fuel Tokens

Once you have Fuel V1 tokens in your wallet, click the "Upgrade to FUEL" button to start the upgrading process. This will take you to two screens.

![Upgrade To FUEL](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-upgrade-fuel-v1/3-convert-to-fuel.png)

The first screen is to approve the amount of tokens to be upgraded.

![Approve Amount](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-upgrade-fuel-v1/4-approve-amount.png)

The second screen is to complete upgrading of Fuel V1 tokens to FUEL tokens.

![Confirm Conversion](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-upgrade-fuel-v1/5-confirm-conversion.png)

That's it! You can now deposit and delegate your tokens to start earning rewards. Since your tokens are on the Ethereum mainnet, you have two options:

1. Stake on Ethereum:

    Use [app.fuel.network/staking/on-ethereum](https://app.fuel.network/staking/on-ethereum) to stake your tokens on the shared sequencer network from Ethereum. Note that this interface differs from the one used for tokens on Fuel Ignition. Follow the instructions provided in [How to Stake on Mainnet Ethereum](./stake-on-ethereum.md).

2. Bridge and Stake on Fuel Ignition:

    Alternatively, you can withdraw and bridge your tokens to Fuel Ignition to benefit from lower costs and higher speeds. Use the [Fuel Bridge](https://app.fuel.network/bridge?from=eth&to=fuel) to transfer your tokens, then stake them using [app.fuel.network/staking/on-fuel](https://app.fuel.network/staking/on-fuel). Follow the instructions provided in the [How to Stake on Fuel Ignition guide](./stake-on-fuel.md).

![Balance](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/how-to-upgrade-fuel-v1/6-balance.png)

> **Note:** It may take some time for your balance to appear on the shared sequencer network. Please don’t panic—your balance will update soon.
