# FUEL Token

| Property                | Details                                    |
|-------------------------|--------------------------------------------|
| Ticker                  | FUEL                                       |
| Total supply at genesis | 10,000,000,000 FUEL                        |
| Decimals                | 9                                          |
| Address                 | [0x675b68aa4d9c2d3bb3f0397048e62e6b7192079c](https://etherscan.io/address/0x675b68aa4d9c2d3bb3f0397048e62e6b7192079c) |
| Inflation Schedule      | 3% annually                                |

## The Role of FUEL

FUEL powers Fuels decentralized sequencer and eliminates gas fees for users by introducing a novel economic incentive structure based on Application Specific Sequencing. By enabling fee-less, web2-like, fee-less experiences for users, FUEL makes blockchain technology more usable and accessible to the masses.

FUEL secures the Fuel sequencing network, pays for chain resources and eliminates transaction fees for users– all while fostering new markets for L2 applications. Beyond sequencing, FUEL is on a mission to make blockchain usable without compromising on decentralization, setting a new standard for rollups in a space dominated by centralized solutions today.

Learn more about the Fuel Sequencer or see the [Fuel Genesis announcement](https://fuel.mirror.xyz/T6A4x8ReVu5ucAdwXXhrJawN9n4op7de4y7xW9MJ8ew) to learn more about the FUEL token's utility and distribution.

## FUEL Overview

![Fuel Banner](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/about/1-fuel-banner.png)

$FUEL will secure the Fuel sequencing network, pay for chain resources and eliminate transaction fees for users while creating new markets for L2 applications.

### 1. Securing the Network

The rollup landscape today is dominated by centralized sequencing solutions, raising concerns about censorship resistance, fairness, and liveness.

Fuel is taking steps to address these challenges. Initially, Fuel will decentralize a network of proposers, then decentralize building, and then will aim to increase the total number of proposers and builders.

The Fuel sequencer employs proof-of-stake (PoS) based on the Tendermint consensus, enabling a decentralized staking network. Users can actively participate in securing the network by delegating their FUEL to sequencer proposers in exchange for a share of staking rewards.

Our vision is to fully decentralize sequencing, which is essential for improving fault tolerance, liveness and censorship resistance. While centralized solutions dominate the space today, Fuel is committed to evolving toward a shared, permissionless network for its rollups.

Validator participation and staking will commence with Fuel Genesis, with detailed information on permissionless staking and running a validator available at a later date.

### 2. Paying for Chain Resources

FUEL will be used to pay for sequencer resources such as data availability, ordering and inclusion of blocks for rollups on the Fuel sequencer. FUEL will also be used for sequencer network fees, which play an essential role in decentralizing L2s built on Fuel as well as ensuring an open and decentralized sequencing network.

Fuel Ignition will continue to accept gas fees in ETH.

### 3. Application Specific Sequencing & Eliminating Fees

FUEL gives dApps greater influence on the inclusion and sequencing of transactions, while avoiding the complexities and limitations of traditional blockchain architectures. Stakers can bond their FUEL tokens to a specific application and earn rewards from those applications in exchange for locking their tokens. This allows transactions to be free for the user and executed according to application specific order. The result is a novel market for L2 chain resources that engages stakers to enable best in class user experiences (i.e. staking resources will receive tokens from applications, and enable free user transactions).

Note: More details about these activities, including instructions on how to delegate and stake will be provided soon.

## Progressive Decentralization

We outline three key phases for advancing the decentralization of the network.

- Phase 0, now completed, established 12 sequencer proposers and introduced initial security measures.
- Phase 1 focuses on decentralized block building and enhanced security.
- Phase 2 aims to significantly scale the network with more proposers, and advanced security features.

This is just the start of our journey, and we're excited to share our plans for advancing the network.

![Progressive Decentralization](https://raw.githubusercontent.com/FuelLabs/fuel-token-overview/refs/heads/main/assets/about/2-progressive-decentralization.png)

## Helpful Links

- Have a question? Ask us a question at [forum.fuel.network](https://forum.fuel.network/) or [Discord](https://discord.com/invite/xfpK4Pe)
- [Genesis Drop Claims](./claim-genesis-drop.md)
- [Upgrade Fuel V1 to FUEL](./fuel-v1-upgrade.md)
- [Stake, Withdrawal and Reward Claims from Fuel Ignition](./stake-on-fuel.md)
- [Stake, Withdrawal and Reward Claims from Ethereum](./stake-on-ethereum.md)
