# Running a Node

This guide is designed to swiftly introduce you to the process of running a local node for the Fuel blockchain.

## What is a Node?

In the context of the Fuel blockchain, a node, often referred to as a 'client', is a piece of software that downloads and maintains a copy of the Fuel blockchain. It verifies the authenticity of every block and transaction, ensuring that your copy is always up-to-date and in sync with the network.

## Why Run Your Own Node?

Running your own node provides several advantages:

1. **Query Freedom:** By hosting your own node, you can execute a higher number of queries without encountering any rate limits.
2. **Network Independence:** Having your own node ensures that you're not reliant on third-party services, giving you full control over your interactions with the Fuel blockchain.

## Types Of Networks

There are two networks you can currently run the nodes for

1. Fuel Ignition: Fuel V2 layer 2 rollup to go on Ethereum Mainnet.

2. Fuel's proposed cosmos based blockchain shared sequencer design prioritizes speed and efficiency, rapidly processing cross-chain transactions. Our fast sequencing empowers developers to build versatile, low-latency cross-chain applications, mitigating typical multi-chain fragmentation.

## Getting Started

Depending on which network you wish to participate in follow the following sections.

1. [Fuel Ignition](./fuel-ignition/index.md)
2. [Fuel Shared Sequencer](./fuel-sequencer/index.md)
