# Asset Library

The Asset Library provides basic helper functions for the [SRC-20; Native Asset Standard](https://docs.fuel.network/docs/sway-standards/src-20-native-asset/), [SRC-3; Mint and Burn Standard](https://docs.fuel.network/docs/sway-standards/src-3-minting-and-burning/), and the [SRC-7; Arbitrary Asset Metadata Standard](https://docs.fuel.network/docs/sway-standards/src-7-asset-metadata/). It is intended to make development of Native Assets using Sway quick and easy while following the standard's specifications.

For implementation details on the Asset Library please see the [Sway Libs Docs](https://fuellabs.github.io/sway-libs/master/sway_libs/asset/asset/).

## [SRC-20 Functionality](./base.md)

The Base or core of any Asset on the Fuel Network must follow the [SRC-20; Native Asset Standard](https://docs.fuel.network/docs/sway-standards/src-20-native-asset/). The Asset Library's [Base](./base.md) section supports the [SRC-20](https://docs.fuel.network/docs/sway-standards/src-20-native-asset/)'s implementation.

## [SRC-3 Functionality](supply.md)

The [SRC-3; Mint and Burn Standard](https://docs.fuel.network/docs/sway-standards/src-3-minting-and-burning/) prescribes an ABI for how Native Assets on the Fuel Network are minted and burned. The Asset Library's [supply](./supply.md) section supports the [SRC-3](https://docs.fuel.network/docs/sway-standards/src-3-minting-and-burning/)'s implementation.

## [SRC-7 Functionality](./metadata.md)

The [SRC-7; Onchain Asset Metadata Standard](https://docs.fuel.network/docs/sway-standards/src-7-asset-metadata/) prescribes an ABI for stateful metadata associated with Native Assets on the Fuel Network. The Asset Library's [metadata](./metadata.md) section supports the [SRC-7](https://docs.fuel.network/docs/sway-standards/src-7-asset-metadata/)'s implementation.
