# Variables

<!-- This section should explain how variables are immutable -->
<!-- immutable_vars:example:start -->
Variables in Sway are _immutable by default_. This means that, by default, once a variable is declared, its value cannot change. This is one of the ways how Sway encourages safe programming, and many modern languages have this same default.
<!-- immutable_vars:example:end -->

Let's take a look at variables in detail.

## Declaring a Variable

Let's look at a variable declaration:

```sway
let foo = 5;
```

Great! We have just declared a variable, `foo`. What do we know about `foo`?

1. It is immutable.
1. Its value is `5`.
1. Its type is `u64`, a 64-bit unsigned integer.

`u64` is the default numeric type, and represents a 64-bit unsigned integer. See the section [Built-in Types](./built_in_types.md) for more details.

We can also make a mutable variable. Let's take a look:

```sway
let mut foo = 5;
foo = 6;
```

Now, `foo` is mutable, and the reassignment to the number `6` is valid. That is, we are allowed to _mutate_ the variable `foo` to change its value.

When assigning to a mutable variable, the right-hand side of the assignment is evaluated before the left-hand side. In the below example, the mutable variable `i` will first be increased and the resulting value of `1` will be stored to `array[1]`, thus resulting in `array` being changed to `[0, 1, 0]`.

```sway
let mut array = [0, 0, 0];
let mut i = 0;

array[i] = {
    i += 1;
    i
};
```

## Type Annotations

<!-- This section should explain type annotations -->
<!-- type_annotations:example:start -->
A variable declaration can contain a _type annotation_. A type annotation serves the purpose of declaring the type, in addition to the value, of a variable.
<!-- type_annotations:example:end -->

Let's take a look:

```sway
let foo: u32 = 5;
```

We have just declared the _type_ of the variable `foo` as a `u32`, which is an unsigned 32-bit integer. Let's take a look at a few other type annotations:

```sway
let bar: str[4] = __to_str_array("sway");
let baz: bool = true;
```

<!-- This section should explain what happens if there is a type conflict -->
<!-- type_conflict:example:start -->
If the value declared cannot be assigned to the declared type, there will be an error generated by the compiler.
<!-- type_conflict:example:end -->
