# Sway Applications

The [Sway-Applications](https://github.com/FuelLabs/sway-applications) Repository contains end-to-end example applications that are written in Sway in order to demonstrate what can be built.

## Asset Management

- [Airdrop](https://github.com/FuelLabs/sway-applications/tree/master/airdrop) is an asset distribution program where users are able to claim assets given a valid merkle proof.
- [Escrow](https://github.com/FuelLabs/sway-applications/tree/master/escrow) is a third party that keeps an asset on behalf of multiple parties.
- [Non-Fungible Native Asset (NFT)](https://github.com/FuelLabs/sway-applications/tree/master/NFT) is an asset contract which provides unique collectibles, identified and differentiated by IDs, where assets contain metadata giving them distinctive characteristics.
- [Fractional Non-Fungible Token (F-NFT)](https://github.com/FuelLabs/sway-applications/tree/master/fractional-NFT) is a token contract which issues shares or partial ownership upon locking an NFT into a vault.
- [Timelock](https://github.com/FuelLabs/sway-applications/tree/master/timelock) is a contract which restricts the execution of a transaction to a specified time range.
- [Native Asset](https://github.com/FuelLabs/sway-applications/tree/master/native-asset) is a basic asset contract that enables the use of Native Assets on Fuel using existing standards and libraries.

## Decentralized Finance

- [English Auction](https://github.com/FuelLabs/sway-applications/tree/master/english-auction) is an auction where users bid up the price of an asset until the bidding period has ended or a reserve has been met.
- [Fundraiser](https://github.com/FuelLabs/sway-applications/tree/master/fundraiser) is a program allowing users to pledge towards a goal.
- [OTC Swap Predicate](https://github.com/FuelLabs/sway-applications/tree/master/OTC-swap-predicate) is a predicate that can be used to propose and execute an atomic swap between two parties without requiring any on-chain state.

## Governance

- [Decentralized Autonomous Organization (DAO)](https://github.com/FuelLabs/sway-applications/tree/master/DAO) is an organization where users get to vote on governance proposals using governance assets.
- [Multi-Signature Wallet](https://github.com/FuelLabs/sway-applications/tree/master/multisig-wallet) is a wallet that requires multiple signatures to execute a transaction.

## Games

- [TicTacToe](https://github.com/FuelLabs/sway-applications/tree/master/TicTacToe) is a game where two players compete to align three markers in a row.

## Other

- [Counter-Script](https://github.com/FuelLabs/sway-applications/tree/master/counter-script) is a script that calls a contract to increment a counter.
- [Name-Registry](https://github.com/FuelLabs/sway-applications/tree/master/name-registry) allows users to perform transactions with human readable names instead of addresses.
- [Oracle](https://github.com/FuelLabs/sway-applications/tree/master/oracle) is a smart contract that provides off-chain data to on-chain applications.
